<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmploymentHistory extends Model
{
    use HasFactory;

    protected $table = 'employment_history';
    protected $primaryKey = 'Employment_id';
    public $incrementing = true;

    protected $fillable = [
        'User_id',
        'Company_name',
        'Position',
        'Start_date',
        'End_date',
        'Currently_working',
        'Description',
    ];

    protected $casts = [
        'Currently_working' => 'boolean',
        'Start_date' => 'date',
        'End_date' => 'date',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }
}
